/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.registry.json;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.kleeslabs.KleeSlabs;
import net.blay09.mods.kleeslabs.KleeSlabsConfig;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.blay09.mods.kleeslabs.registry.SlabRegistry;
import net.blay09.mods.kleeslabs.registry.SlabRegistryData;
import net.blay09.mods.kleeslabs.registry.json.JsonCompatData;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;

public class JsonCompatLoader
implements class_4013 {
    private static final Gson gson = new Gson();

    public void method_14491(class_3300 resourceManager) {
        for (class_2960 resourceLocation : resourceManager.method_14488("kleeslabs_compat", it -> it.endsWith(".json"))) {
            try {
                class_3298 resource = resourceManager.method_14486(resourceLocation);
                try {
                    InputStreamReader reader = new InputStreamReader(resource.method_14482());
                    JsonCompatLoader.load((JsonCompatData)gson.fromJson((Reader)reader, JsonCompatData.class));
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (Exception e) {
                KleeSlabs.logger.error("Parsing error loading KleeSlabs Data File at {}", (Object)resourceLocation, (Object)e);
            }
        }
    }

    private static boolean isCompatEnabled(String modId) {
        return !KleeSlabsConfig.getActive().disabledCompat.contains(modId);
    }

    private static void load(JsonCompatData data) {
        Map<String, String> mappedSlabs;
        Class<?> converterClass;
        String modId = data.getModId();
        if (!modId.equals("minecraft") && !Balm.isModLoaded((String)modId) || !JsonCompatLoader.isCompatEnabled(modId)) {
            return;
        }
        boolean isSilent = data.isSilent();
        String converterName = data.getConverter();
        try {
            converterClass = Class.forName("net.blay09.mods.kleeslabs.converter." + converterName);
        }
        catch (ClassNotFoundException ignored) {
            try {
                converterClass = Class.forName(converterName);
            }
            catch (ClassNotFoundException e) {
                KleeSlabs.logger.error("Slab converter class was not found: {}", (Object)converterName);
                return;
            }
        }
        if (!SlabConverter.class.isAssignableFrom(converterClass)) {
            KleeSlabs.logger.error("Slab converter class was not found: {}", (Object)converterName);
            return;
        }
        Set<String> slabs = data.getSlabs();
        if (slabs != null) {
            for (String string : slabs) {
                class_2248 class_22482 = JsonCompatLoader.parseBlock(modId, string);
                if (class_22482 != class_2246.field_10124) {
                    SlabRegistry.registerSlab(new SlabRegistryData(converterClass, class_22482, class_22482));
                    continue;
                }
                if (isSilent) continue;
                KleeSlabs.logger.error("Slab {}:{} could not be found.", (Object)modId, (Object)string);
            }
        }
        if ((mappedSlabs = data.getMappedSlabs()) != null) {
            for (Map.Entry<String, String> entry : mappedSlabs.entrySet()) {
                String singleSlabName = entry.getKey();
                class_2248 singleSlab = JsonCompatLoader.parseBlock(modId, singleSlabName);
                if (singleSlab == class_2246.field_10124) {
                    KleeSlabs.logger.error("Slab {}:{} could not be found.", (Object)modId, (Object)singleSlabName);
                    continue;
                }
                String doubleSlabName = entry.getValue();
                class_2248 doubleSlab = JsonCompatLoader.parseBlock(modId, doubleSlabName);
                if (doubleSlab == class_2246.field_10124) {
                    KleeSlabs.logger.error("Slab {}:{} could not be found.", (Object)modId, (Object)doubleSlabName);
                    continue;
                }
                SlabRegistry.registerSlab(new SlabRegistryData(converterClass, singleSlab, doubleSlab));
            }
        }
        String string = data.getPatternSearch() != null ? data.getPatternSearch() : ".+";
        Pattern pattern = Pattern.compile(string);
        Matcher matcherSearch = pattern.matcher("");
        String patternReplace = data.getPatternReplace() != null ? data.getPatternReplace() : "$0_double";
        Set<String> patternSlabs = data.getPatternSlabs();
        if (patternSlabs != null) {
            for (String singleSlabName : patternSlabs) {
                matcherSearch.reset(singleSlabName);
                String doubleSlabName = matcherSearch.replaceFirst(patternReplace);
                class_2248 singleSlab = JsonCompatLoader.parseBlock(modId, singleSlabName);
                if (singleSlab == class_2246.field_10124) {
                    KleeSlabs.logger.error("Slab {}:{} could not be found.", (Object)modId, (Object)singleSlabName);
                    continue;
                }
                class_2248 doubleSlab = JsonCompatLoader.parseBlock(modId, doubleSlabName);
                if (doubleSlab == class_2246.field_10124) {
                    KleeSlabs.logger.error("Slab {}:{} could not be found.", (Object)modId, (Object)doubleSlabName);
                    continue;
                }
                SlabRegistry.registerSlab(new SlabRegistryData(converterClass, singleSlab, doubleSlab));
            }
        }
    }

    private static class_2248 parseBlock(String modId, String name) {
        class_2248 block;
        int colon = name.indexOf(58);
        if (colon != -1) {
            modId = name.substring(0, colon);
            name = name.substring(colon + 1);
        }
        return (block = Balm.getRegistries().getBlock(new class_2960(modId, name))) != null ? block : class_2246.field_10124;
    }
}

